import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import * as SecureStore from "expo-secure-store";

import { BASE_API_URL_STG } from "@env";
import { mutationResponse } from "../util/processResponse.js";

const LOGIN_URL = `${BASE_API_URL_STG}/user/login`;

const initialState = {
    reCaptchaToken: false,
    access_token: null,
    user: null,
    loading: false,
};

export const signInUsingEmailAndPassword = createAsyncThunk(
    "auth/login",
    async (params) => {
        const { data } = params;
        try {
            const response = await mutationResponse(LOGIN_URL, "POST", data);
            return response;
        } catch (err) {}
    }
);

const signInUsingEmailAndPasswordSlice1 = createSlice({
    name: "login",
    initialState,
    reducers: {
        login: (state, { payload }) => {
            state.access_token = payload.access_token;
            state.user = payload.user;
            state.loading = false;
            SecureStore.setItemAsync("isLoggedIn", JSON.stringify(payload));
        },
        logout: (state) => {
            state.access_token = null;
            state.user = null;
            state.reCaptchaToken = false;
            state.loading = false;
            SecureStore.deleteItemAsync("isLoggedIn");
        },
        storeRecaptchaToken: (state, { payload }) => {
            state.reCaptchaToken = payload;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(signInUsingEmailAndPassword.pending, (state) => {
            state.loading = true;
            state.access_token = null;
            state.user = null;
        });
        builder.addCase(
            signInUsingEmailAndPassword.fulfilled,
            (state, { payload }) => {
                const { access_token, user } = payload?.records || {};
                state.loading = false;
                state.access_token = access_token;
                state.user = user;
            }
        );
        builder.addCase(signInUsingEmailAndPassword.rejected, (state) => {
            state.loading = false;
            state.access_token = null;
            state.user = null;
        });
    },
});

export default signInUsingEmailAndPasswordSlice1.reducer;
export const { login, logout, storeRecaptchaToken } =
    signInUsingEmailAndPasswordSlice1.actions;
